// MyViewManager.h: interface for the MyViewManager class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MYVIEWMANAGER_H__B640C63B_62BB_4E37_81CB_584871DA2FAF__INCLUDED_)
#define AFX_MYVIEWMANAGER_H__B640C63B_62BB_4E37_81CB_584871DA2FAF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class MyVideoWnd;
class MyLayout;

enum {LAYOUT01 = 0, LAYOUT04 = 1, LAYOUT09 = 2, LAYOUT16 = 3, LAYOUT36 = 4, LAYOUT64 = 5, LAYOUT144 = 6};

class MyViewManager
{

public:

	void DelAllChannelFromView(int nMode, int nView);

	void AddChannelToView(int nMode, int nView,  int nChannelNum);

	void Activate(int nMode, BOOL bForce = FALSE);

	void Notify(MyVideoWnd* pVideoWnd, int nMode);

	void SetLayoutRect(RECT &rect);

	void SetVideoWnds(int nMode, MyVideoWnd* listWnd, int nCount);

	void SwapView(MyVideoWnd* pVideoWnd1, MyVideoWnd* pVideoWnd2);

	void ReleaseResource();

	BOOL IsWinMaximize();

	MyViewManager();

	virtual ~MyViewManager();

private:

	MyLayout*							m_pActiveLayout;

	CArray<MyLayout*, MyLayout*&>		m_listLayout;
};

#endif // !defined(AFX_MYVIEWMANAGER_H__B640C63B_62BB_4E37_81CB_584871DA2FAF__INCLUDED_)
